<?php
ob_start();
oturumKontrol();

// UUID oluşturma fonksiyonu
function generateUUID() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}


if (!isset($_GET['id'])) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

$fatura_id = $_GET['id'];

// Fatura bilgilerini getir
$sorgu = $db->prepare("
    SELECT f.*, m.ad as musteri_ad, m.soyad as musteri_soyad, m.musteri_turu,
           m.telefon, m.eposta, m.adres, m.vergi_dairesi, m.vergi_no, m.tc_kimlik_no
    FROM faturalar f
    LEFT JOIN musteriler m ON f.musteri_id = m.id
    WHERE f.id = ?
");
$sorgu->execute([$fatura_id]);
$fatura = $sorgu->fetch(PDO::FETCH_ASSOC);


// Online ödeme tablosu oluştur
$sorgu = $db->query("CREATE TABLE IF NOT EXISTS online_odemeler (
    id CHAR(36) PRIMARY KEY,
    fatura_id CHAR(36) NOT NULL,
    tutar DECIMAL(10,2) NOT NULL,
    durum ENUM('Bekliyor', 'Ödendi', 'İptal') NOT NULL DEFAULT 'Bekliyor',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (fatura_id) REFERENCES faturalar(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci");

if (!$fatura) {
    header("Location: index.php?sayfa=fatura/liste");
    exit;
}

// Fatura kalemlerini getir
$sorgu = $db->prepare("SELECT * FROM fatura_kalemleri WHERE fatura_id = ?");
$sorgu->execute([$fatura_id]);
$kalemler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

$hata = '';
$basarili = '';

// PDF oluştur fonksiyonunu güncelle
function createPDF($fatura, $kalemler) {
    require_once('inc/tcpdf/tcpdf.php');
    // TCPDF sınıfını genişlet
    class MYPDF extends TCPDF {
        public function Header() {
            // Boş header - özelleştirilebilir
        }
        
        public function Footer() {
            // Footer metni
            $this->SetY(-15);
            $this->SetFont('dejavusans', 'I', 8);
            $this->Cell(0, 10, 'Sayfa '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C');
        }
    }
    
    // PDF oluştur
    $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    
    // PDF meta bilgileri
    $pdf->SetCreator('Hosting Yönetim Sistemi');
    $pdf->SetAuthor('Şirket Adı');
    $pdf->SetTitle('Fatura #' . $fatura['fatura_no']);
    
    // Varsayılan header ve footer'ı kaldır
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(true);
    
    // Font ayarları
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetMargins(15, 15, 15);
    
    // Sayfa ayarları
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    
    // Şirket logosu (varsa)
    // $pdf->Image('logo.png', 15, 15, 50);
    
    // Şirket bilgileri
    $pdf->SetFont('dejavusans', 'B', 14);
    $pdf->Cell(0, 10, 'ŞİRKET ADI', 0, 1, 'L');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(0, 6, 'Adres: Şirket Adresi', 0, 1, 'L');
    $pdf->Cell(0, 6, 'Tel: +90 XXX XXX XX XX', 0, 1, 'L');
    $pdf->Cell(0, 6, 'E-posta: info@sirket.com', 0, 1, 'L');
    
    // Fatura başlığı
    $pdf->Ln(10);
    $pdf->SetFont('dejavusans', 'B', 16);
    $pdf->Cell(0, 10, 'FATURA', 0, 1, 'C');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(0, 6, 'Fatura No: ' . $fatura['fatura_no'], 0, 1, 'R');
    $pdf->Cell(0, 6, 'Tarih: ' . date('d.m.Y', strtotime($fatura['fatura_tarihi'])), 0, 1, 'R');
    
    // Müşteri bilgileri
    $pdf->Ln(5);
    $pdf->SetFont('dejavusans', 'B', 12);
    $pdf->Cell(0, 8, 'FATURA ADRESİ', 0, 1, 'L');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(0, 6, $fatura['musteri_ad'] . ' ' . $fatura['musteri_soyad'], 0, 1, 'L');
    
    if ($fatura['musteri_turu'] == 'Kurumsal') {
        $pdf->Cell(0, 6, 'Vergi Dairesi: ' . $fatura['vergi_dairesi'], 0, 1, 'L');
        $pdf->Cell(0, 6, 'Vergi No: ' . $fatura['vergi_no'], 0, 1, 'L');
    } else {
        $pdf->Cell(0, 6, 'T.C. Kimlik No: ' . $fatura['tc_kimlik_no'], 0, 1, 'L');
    }
    
    $pdf->MultiCell(0, 6, $fatura['adres'], 0, 'L');
    $pdf->Cell(0, 6, 'Tel: ' . $fatura['telefon'], 0, 1, 'L');
    $pdf->Cell(0, 6, 'E-posta: ' . $fatura['eposta'], 0, 1, 'L');
    
    // Fatura kalemleri tablosu
    $pdf->Ln(10);
    $pdf->SetFont('dejavusans', 'B', 10);
    
    // Tablo başlıkları
    $w = array(60, 25, 25, 30, 35);
    $pdf->SetFillColor(240, 240, 240);
    $pdf->Cell($w[0], 7, 'Açıklama', 1, 0, 'C', true);
    $pdf->Cell($w[1], 7, 'Birim', 1, 0, 'C', true);
    $pdf->Cell($w[2], 7, 'Miktar', 1, 0, 'C', true);
    $pdf->Cell($w[3], 7, 'Birim Fiyat', 1, 0, 'C', true);
    $pdf->Cell($w[4], 7, 'Toplam', 1, 1, 'C', true);
    
    // Tablo içeriği
    $pdf->SetFont('dejavusans', '', 10);
    $fill = false;
    foreach ($kalemler as $kalem) {
        // Hücre yüksekliğini otomatik ayarla
        $pdf->MultiCell($w[0], 6, $kalem['aciklama'], 1, 'L', $fill, 0);
        $pdf->Cell($w[1], 6, $kalem['birim'], 1, 0, 'C', $fill);
        $pdf->Cell($w[2], 6, number_format($kalem['miktar'], 2, ',', '.'), 1, 0, 'R', $fill);
        $pdf->Cell($w[3], 6, number_format($kalem['birim_fiyat'], 2, ',', '.') . ' ₺', 1, 0, 'R', $fill);
        $pdf->Cell($w[4], 6, number_format($kalem['toplam'], 2, ',', '.') . ' ₺', 1, 1, 'R', $fill);
        $fill = !$fill;
    }
    
    // Toplam bilgileri
    $pdf->SetFont('dejavusans', 'B', 10);
    $pdf->Cell(array_sum($w) - $w[4], 6, 'Ara Toplam:', 1, 0, 'R');
    $pdf->Cell($w[4], 6, number_format($fatura['ara_toplam'], 2, ',', '.') . ' ₺', 1, 1, 'R');
    
    $pdf->Cell(array_sum($w) - $w[4], 6, 'KDV (%' . $fatura['kdv_oran'] . '):', 1, 0, 'R');
    $pdf->Cell($w[4], 6, number_format($fatura['kdv_tutar'], 2, ',', '.') . ' ₺', 1, 1, 'R');
    
    $pdf->SetFillColor(220, 220, 220);
    $pdf->Cell(array_sum($w) - $w[4], 6, 'Genel Toplam:', 1, 0, 'R', true);
    $pdf->Cell($w[4], 6, number_format($fatura['genel_toplam'], 2, ',', '.') . ' ₺', 1, 1, 'R', true);
    
    // Banka bilgileri
    $pdf->Ln(10);
    $pdf->SetFont('dejavusans', 'B', 10);
    $pdf->Cell(0, 6, 'Banka Hesap Bilgileri:', 0, 1, 'L');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->Cell(0, 6, 'Banka: XXX Bank', 0, 1, 'L');
    $pdf->Cell(0, 6, 'Şube: XXX Şubesi', 0, 1, 'L');
    $pdf->Cell(0, 6, 'IBAN: TRXX XXXX XXXX XXXX XXXX XXXX XX', 0, 1, 'L');
    
    // Son notlar
    $pdf->Ln(10);
    $pdf->SetFont('dejavusans', '', 8);
    $pdf->MultiCell(0, 4, 'Not: Bu fatura elektronik ortamda hazırlanmıştır ve geçerli bir mali belgedir.', 0, 'L');
    
    return $pdf;
}


// E-posta gönder fonksiyonunu güncelle
function sendEmail($to, $subject, $message, $pdf_content) {
    require_once('inc/phpmailer/PHPMailer.php');
    require_once('inc/phpmailer/SMTP.php');
    require_once('inc/phpmailer/Exception.php');

    $mail = new PHPMailer\PHPMailer\PHPMailer(true);

    try {
        // Server ayarları
        $mail->isSMTP();
        $mail->Host = 'mail.torossogutma.com.tr'; // SMTP sunucunuz
        $mail->SMTPAuth = true;
        $mail->Username = 'cem@torossogutma.com.tr'; // SMTP kullanıcı adı
        $mail->Password = 'Ts147258-+'; // SMTP şifre
        $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;
        $mail->CharSet = 'UTF-8';

        // Gönderici ve alıcı
        $mail->setFrom('cem@torossogutma.com.tr', 'Epifiz Web Ajans');
        $mail->addAddress($to);

        // İçerik
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $message;

        // PDF ekle
        $mail->addStringAttachment($pdf_content, 'fatura.pdf');

        return $mail->send();
    } catch (Exception $e) {
        error_log("Mail gönderme hatası: " . $mail->ErrorInfo);
        return false;
    }
}


// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        // PDF oluştur
        $pdf = createPDF($fatura, $kalemler);
        
        // PDF'i string olarak al
        $pdf_content = $pdf->Output('', 'S');
        

        // Online ödeme kaydı oluştur
        $online_odeme_id = generateUUID();
        $sorgu = $db->prepare("INSERT INTO online_odemeler (id, fatura_id, tutar) VALUES (?, ?, ?)");
        $sorgu->execute([$online_odeme_id, $fatura_id, $fatura['genel_toplam']]);

        // Online ödeme linki oluştur
        $online_odeme_link = SITE_URL . "/odeme.php?id=" . $online_odeme_id;


        // E-posta içeriği
        $subject = "Fatura #" . $fatura['fatura_no'];
        $message = "
            <html>
            <body>
                <h2>Sayın {$fatura['musteri_ad']} {$fatura['musteri_soyad']},</h2>
                <p>#{$fatura['fatura_no']} numaralı faturanız ekte yer almaktadır.</p>
                <p><strong>Fatura Tarihi:</strong> " . date('d.m.Y', strtotime($fatura['fatura_tarihi'])) . "</p>
                <p><strong>Son Ödeme Tarihi:</strong> " . date('d.m.Y', strtotime($fatura['son_odeme_tarihi'])) . "</p>
                <p><strong>Tutar:</strong> " . number_format($fatura['genel_toplam'], 2, ',', '.') . " ₺</p>
                <hr>
                <p>Banka hesap bilgilerimiz:</p>
                <p>
                    Banka: XXX Bank<br>
                    Şube: XXX Şubesi<br>
                    IBAN: TRXX XXXX XXXX XXXX XXXX XXXX XX
                </p>
                <div style='margin: 30px 0; text-align: center;'>
                    <a href='{$online_odeme_link}' 
                       style='background: #28a745; color: #fff; padding: 12px 25px; text-decoration: none; border-radius: 4px;'>
                        Kredi Kartı ile Öde
                    </a>
                </div>
                <p>Saygılarımızla,<br>Şirket Adı</p>
            </body>
            </html>
        ";
        
        // E-postayı gönder
        if (sendEmail($fatura['eposta'], $subject, $message, $pdf_content)) {
            $basarili = "Fatura başarıyla gönderildi.";
        } else {
            $hata = "E-posta gönderilirken bir hata oluştu.";
        }
        
    } catch (Exception $e) {
        $hata = "Bir hata oluştu: " . $e->getMessage();
    }
}
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=fatura/liste">Faturalar</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=fatura/goruntule&id=<?php echo $fatura_id; ?>">Fatura Detayı</a></li>
        <li class="breadcrumb-item active">Fatura Gönder</li>
    </ol>
</nav>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="bi bi-envelope me-2"></i>
            Fatura Gönder
            <small class="text-muted">(<?php echo htmlspecialchars($fatura['fatura_no']); ?>)</small>
        </h5>
    </div>
    <div class="card-body">
        <?php if ($hata): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <?php echo $hata; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($basarili): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle-fill me-2"></i>
                <?php echo $basarili; ?>
            </div>
        <?php endif; ?>
        
        <div class="row">
            <div class="col-md-6">
                <h6 class="fw-bold mb-3">Fatura Bilgileri</h6>
                <table class="table table-sm">
                    <tr>
                        <td class="fw-bold">Fatura No:</td>
                        <td><?php echo htmlspecialchars($fatura['fatura_no']); ?></td>
                    </tr>
                    <tr>
                        <td class="fw-bold">Fatura Tarihi:</td>
                        <td><?php echo date('d.m.Y', strtotime($fatura['fatura_tarihi'])); ?></td>
                    </tr>
                    <tr>
                        <td class="fw-bold">Tutar:</td>
                        <td><?php echo number_format($fatura['genel_toplam'], 2, ',', '.'); ?> ₺</td>
                    </tr>
                </table>
            </div>
            
            <div class="col-md-6">
                <h6 class="fw-bold mb-3">Müşteri Bilgileri</h6>
                <table class="table table-sm">
                    <tr>
                        <td class="fw-bold">Ad Soyad:</td>
                        <td><?php echo htmlspecialchars($fatura['musteri_ad'] . ' ' . $fatura['musteri_soyad']); ?></td>
                    </tr>
                    <tr>
                        <td class="fw-bold">E-posta:</td>
                        <td><?php echo htmlspecialchars($fatura['eposta']); ?></td>
                    </tr>
                    <tr>
                        <td class="fw-bold">Telefon:</td>
                        <td><?php echo htmlspecialchars($fatura['telefon']); ?></td>
                    </tr>
                </table>
            </div>
        </div>
        
        <hr>
        
        <form method="POST" action="" class="mt-4">
            <div class="alert alert-info">
                <i class="bi bi-info-circle-fill me-2"></i>
                Fatura PDF olarak oluşturulup müşterinin e-posta adresine gönderilecektir.
            </div>
            
            <div class="mt-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-envelope me-2"></i>
                    Faturayı Gönder
                </button>
                <a href="index.php?sayfa=fatura/goruntule&id=<?php echo $fatura_id; ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i>
                    İptal
                </a>
            </div>
        </form>
    </div>
</div>