<?php
ob_start();
oturumKontrol();

// Get admin list
$sorgu = $db->query("SELECT * FROM yonetici ORDER BY created_at DESC");
$yoneticiler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Add new admin
if (isset($_POST['yonetici_ekle'])) {
    $ad_soyad = guvenlik($_POST['ad_soyad']);
    $kullanici_adi = guvenlik($_POST['kullanici_adi']);
    $sifre = $_POST['sifre'];
    $yetki_seviyesi = (int)$_POST['yetki_seviyesi'];
    
    if (empty($ad_soyad) || empty($kullanici_adi) || empty($sifre)) {
        $hata = 'Lütfen tüm alanları doldurun.';
    } elseif (strlen($sifre) < 8) {
        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';
    } else {
        try {
            // Check if username exists
            $kontrol = $db->prepare("SELECT id FROM yonetici WHERE kullanici_adi = ?");
            $kontrol->execute([$kullanici_adi]);
            
            if ($kontrol->rowCount() > 0) {
                $hata = 'Bu kullanıcı adı zaten kullanılıyor.';
            } else {
                $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
                
                $sorgu = $db->prepare("INSERT INTO yonetici (ad_soyad, kullanici_adi, sifre, yetki_seviyesi) VALUES (?, ?, ?, ?)");
                $sonuc = $sorgu->execute([$ad_soyad, $kullanici_adi, $sifre_hash, $yetki_seviyesi]);
                
                if ($sonuc) {
                    $basarili = 'Yönetici başarıyla eklendi.';
                    header("Refresh:2");
                }
            }
        } catch (PDOException $e) {
            $hata = 'Bir hata oluştu: ' . $e->getMessage();
        }
    }
}

// Delete admin
if (isset($_POST['yonetici_sil'])) {
    $id = (int)$_POST['id'];
    
    try {
        // Prevent deleting the last admin
        $kontrol = $db->query("SELECT COUNT(*) FROM yonetici");
        if ($kontrol->fetchColumn() <= 1) {
            $hata = 'Son yönetici silinemez!';
        } else {
            $sorgu = $db->prepare("DELETE FROM yonetici WHERE id = ?");
            $sonuc = $sorgu->execute([$id]);
            
            if ($sonuc) {
                $basarili = 'Yönetici başarıyla silindi.';
                header("Refresh:2");
            }
        }
    } catch (PDOException $e) {
        $hata = 'Bir hata oluştu: ' . $e->getMessage();
    }
}

// Update admin
if (isset($_POST['yonetici_guncelle'])) {
    $id = (int)$_POST['id'];
    $ad_soyad = guvenlik($_POST['ad_soyad']);
    $kullanici_adi = guvenlik($_POST['kullanici_adi']);
    $yetki_seviyesi = (int)$_POST['yetki_seviyesi'];
    $sifre = $_POST['sifre']; // Optional
    
    if (empty($ad_soyad) || empty($kullanici_adi)) {
        $hata = 'Ad Soyad ve Kullanıcı Adı alanları zorunludur.';
    } else {
        try {
            // Check if username exists (except current user)
            $kontrol = $db->prepare("SELECT id FROM yonetici WHERE kullanici_adi = ? AND id != ?");
            $kontrol->execute([$kullanici_adi, $id]);
            
            if ($kontrol->rowCount() > 0) {
                $hata = 'Bu kullanıcı adı başka bir yönetici tarafından kullanılıyor.';
            } else {
                if (!empty($sifre)) {
                    if (strlen($sifre) < 8) {
                        $hata = 'Şifre en az 8 karakter uzunluğunda olmalıdır.';
                    } else {
                        $sifre_hash = password_hash($sifre, PASSWORD_DEFAULT);
                        $sorgu = $db->prepare("UPDATE yonetici SET ad_soyad = ?, kullanici_adi = ?, sifre = ?, yetki_seviyesi = ? WHERE id = ?");
                        $sonuc = $sorgu->execute([$ad_soyad, $kullanici_adi, $sifre_hash, $yetki_seviyesi, $id]);
                    }
                } else {
                    $sorgu = $db->prepare("UPDATE yonetici SET ad_soyad = ?, kullanici_adi = ?, yetki_seviyesi = ? WHERE id = ?");
                    $sonuc = $sorgu->execute([$ad_soyad, $kullanici_adi, $yetki_seviyesi, $id]);
                }
                
                if (isset($sonuc) && $sonuc) {
                    $basarili = 'Yönetici bilgileri güncellendi.';
                    header("Refresh:2");
                }
            }
        } catch (PDOException $e) {
            $hata = 'Bir hata oluştu: ' . $e->getMessage();
        }
    }
}
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
        <li class="breadcrumb-item"><a href="index.php?sayfa=ayarlar">Ayarlar</a></li>
        <li class="breadcrumb-item active">Yönetici Hesapları</li>
    </ol>
</nav>

<!-- Messages -->
<?php if (isset($hata)): ?>
    <div class="alert alert-danger">
        <i class="bi bi-exclamation-triangle-fill me-2"></i>
        <?php echo $hata; ?>
    </div>
<?php endif; ?>

<?php if (isset($basarili)): ?>
    <div class="alert alert-success">
        <i class="bi bi-check-circle-fill me-2"></i>
        <?php echo $basarili; ?>
    </div>
<?php endif; ?>

<!-- Admin List -->
<div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="bi bi-people me-2"></i>
            Yönetici Hesapları
        </h5>
        <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#yeniYoneticiModal">
            <i class="bi bi-person-plus me-2"></i>
            Yeni Yönetici
        </button>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Ad Soyad</th>
                        <th>Kullanıcı Adı</th>
                        <th>Yetki Seviyesi</th>
                        <th>Son Giriş</th>
                        <th>Durum</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($yoneticiler as $yonetici): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($yonetici['ad_soyad']); ?></td>
                        <td><?php echo htmlspecialchars($yonetici['kullanici_adi']); ?></td>
                        <td>
                            <?php
                            $yetki_badge = '';
                            switch($yonetici['yetki_seviyesi']) {
                                case 1:
                                    $yetki_badge = 'bg-info';
                                    $yetki_text = 'Personel';
                                    break;
                                case 2:
                                    $yetki_badge = 'bg-success';
                                    $yetki_text = 'Yönetici';
                                    break;
                                case 3:
                                    $yetki_badge = 'bg-danger';
                                    $yetki_text = 'Süper Admin';
                                    break;
                                default:
                                    $yetki_badge = 'bg-secondary';
                                    $yetki_text = 'Belirsiz';
                            }
                            ?>
                            <span class="badge <?php echo $yetki_badge; ?>">
                                <?php echo $yetki_text; ?>
                            </span>
                        </td>
                        <td>
                            <?php if ($yonetici['son_giris']): ?>
                                <?php echo date('d.m.Y H:i', strtotime($yonetici['son_giris'])); ?>
                                <br>
                                <small class="text-muted">
                                    <?php echo $yonetici['son_giris_ip']; ?>
                                </small>
                            <?php else: ?>
                                <span class="text-muted">Henüz giriş yapmadı</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($yonetici['durum'] == 'Aktif'): ?>
                                <span class="badge bg-success">Aktif</span>
                            <?php else: ?>
                                <span class="badge bg-danger">Pasif</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-warning btn-sm" 
                                        onclick="yoneticiDuzenle(<?php echo htmlspecialchars(json_encode($yonetici)); ?>)">
                                    <i class="bi bi-pencil me-1"></i>
                                    Düzenle
                                </button>
                                <?php if ($_SESSION['kullanici_id'] != $yonetici['id']): ?>
                                <button type="button" class="btn btn-danger btn-sm" 
                                        onclick="yoneticiSil(<?php echo $yonetici['id']; ?>)">
                                    <i class="bi bi-trash me-1"></i>
                                    Sil
                                </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- New Admin Modal -->
<div class="modal fade" id="yeniYoneticiModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-person-plus me-2"></i>
                    Yeni Yönetici Ekle
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="">
                <input type="hidden" name="yonetici_ekle" value="1">
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="ad_soyad" class="form-label">Ad Soyad</label>
                        <input type="text" class="form-control" id="ad_soyad" name="ad_soyad" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="kullanici_adi" class="form-label">Kullanıcı Adı</label>
                        <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="sifre" class="form-label">Şifre</label>
                        <div class="input-group">
                            <input type="password" class="form-control" id="sifre" name="sifre" 
                                   minlength="8" required>
                            <button class="btn btn-outline-secondary" type="button" id="sifreGoster"
                                    data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                                <i class="bi bi-eye"></i>
                            </button>
                            <button class="btn btn-outline-secondary" type="button" id="rastgeleSifre"
                                    data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                                <i class="bi bi-shuffle"></i>
                            </button>
                        </div>
                        <small class="text-muted">En az 8 karakter</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="yetki_seviyesi" class="form-label">Yetki Seviyesi</label>
                        <select class="form-select" id="yetki_seviyesi" name="yetki_seviyesi" required>
                            <option value="1">Personel</option>
                            <option value="2">Yönetici</option>
                            <option value="3">Süper Admin</option>
                        </select>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Ekle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Admin Modal -->
<div class="modal fade" id="duzenleModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-pencil me-2"></i>
                    Yönetici Düzenle
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="">
                <input type="hidden" name="yonetici_guncelle" value="1">
                <input type="hidden" name="id" id="duzenle_id">
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="duzenle_ad_soyad" class="form-label">Ad Soyad</label>
                        <input type="text" class="form-control" id="duzenle_ad_soyad" name="ad_soyad" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="duzenle_kullanici_adi" class="form-label">Kullanıcı Adı</label>
                        <input type="text" class="form-control" id="duzenle_kullanici_adi" name="kullanici_adi" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="duzenle_sifre" class="form-label">Yeni Şifre</label>
                        <div class="input-group">
                            <input type="password" class="form-control" id="duzenle_sifre" name="sifre" 
                                   minlength="8">
                            <button class="btn btn-outline-secondary" type="button" id="duzenle_sifreGoster"
                                    data-bs-toggle="tooltip" title="Şifreyi Göster/Gizle">
                                <i class="bi bi-eye"></i>
                            </button>
                            <button class="btn btn-outline-secondary" type="button" id="duzenle_rastgeleSifre"
                                    data-bs-toggle="tooltip" title="Rastgele Şifre Oluştur">
                                <i class="bi bi-shuffle"></i>
                            </button>
                        </div>
                        <small class="text-muted">Değiştirmek istemiyorsanız boş bırakın</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="duzenle_yetki_seviyesi" class="form-label">Yetki Seviyesi</label>
                        <select class="form-select" id="duzenle_yetki_seviyesi" name="yetki_seviyesi" required>
                            <option value="1">Personel</option>
                            <option value="2">Yönetici</option>
                            <option value="3">Süper Admin</option>
                        </select>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Form -->
<form id="silForm" method="POST" style="display: none;">
    <input type="hidden" name="yonetici_sil" value="1">
    <input type="hidden" name="id" id="sil_id">
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tooltips'i aktifleştir
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    
    // Şifre göster/gizle fonksiyonu
    function sifreGosterGizle(input, button) {
        const tip = input.type === 'password' ? 'text' : 'password';
        input.type = tip;
        const icon = button.querySelector('i');
        icon.className = tip === 'password' ? 'bi bi-eye' : 'bi bi-eye-slash';
        
        // Tooltip metnini güncelle
        const tooltip = bootstrap.Tooltip.getInstance(button);
        if (tooltip) {
            tooltip.setContent({ '.tooltip-inner': tip === 'password' ? 'Şifreyi Göster' : 'Şifreyi Gizle' });
        }
    }
    
    // Rastgele şifre oluştur fonksiyonu
    function rastgeleSifreOlustur(input, button) {
        const karakterler = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*';
        let sifre = '';
        for (let i = 0; i < 12; i++) {
            sifre += karakterler.charAt(Math.floor(Math.random() * karakterler.length));
        }
        input.type = 'text';
        input.value = sifre;
        button.querySelector('i').className = 'bi bi-eye-slash';
    }
    
    // Yeni yönetici için şifre işlemleri
    const sifreInput = document.getElementById('sifre');
    const sifreGoster = document.getElementById('sifreGoster');
    const rastgeleSifre = document.getElementById('rastgeleSifre');
    
    if (sifreGoster) {
        sifreGoster.addEventListener('click', () => sifreGosterGizle(sifreInput, sifreGoster));
    }
    
    if (rastgeleSifre) {
        rastgeleSifre.addEventListener('click', () => rastgeleSifreOlustur(sifreInput, sifreGoster));
    }
    
    // Düzenleme için şifre işlemleri
    const duzenleSifreInput = document.getElementById('duzenle_sifre');
    const duzenleSifreGoster = document.getElementById('duzenle_sifreGoster');
    const duzenleRastgeleSifre = document.getElementById('duzenle_rastgeleSifre');
    
    if (duzenleSifreGoster) {
        duzenleSifreGoster.addEventListener('click', () => sifreGosterGizle(duzenleSifreInput, duzenleSifreGoster));
    }
    
    if (duzenleRastgeleSifre) {
        duzenleRastgeleSifre.addEventListener('click', () => rastgeleSifreOlustur(duzenleSifreInput, duzenleSifreGoster));
    }
});

// Yönetici düzenleme modalını aç
function yoneticiDuzenle(yonetici) {
    document.getElementById('duzenle_id').value = yonetici.id;
    document.getElementById('duzenle_ad_soyad').value = yonetici.ad_soyad;
    document.getElementById('duzenle_kullanici_adi').value = yonetici.kullanici_adi;
    document.getElementById('duzenle_yetki_seviyesi').value = yonetici.yetki_seviyesi;
    
    const modal = new bootstrap.Modal(document.getElementById('duzenleModal'));
    modal.show();
}

// Yönetici silme işlemi
function yoneticiSil(id) {
    if (confirm('Bu yöneticiyi silmek istediğinizden emin misiniz?')) {
        document.getElementById('sil_id').value = id;
        document.getElementById('silForm').submit();
    }
}
</script>

<?php ob_end_flush(); ?>