<?php
ob_start();
oturumKontrol(); // Oturum kontrolü

// Müşteriler listesini al
$sorgu = $db->query("SELECT * FROM musteriler ORDER BY ad, soyad");
$musteriler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// URL'den parametreleri al: 'user' ve 'server'
if (!isset($_GET['user']) || !isset($_GET['server'])) {
    echo "Gerekli parametreler eksik.";
    exit;
}

$user = $_GET['user'];
$serverName = $_GET['server'];

// Sunucular tablosundan sunucu adından sunucu_id'yi al
$sorgu = $db->prepare("SELECT id FROM sunucular WHERE sunucu_adi = ?");
$sorgu->execute([$serverName]);
$serverRow = $sorgu->fetch(PDO::FETCH_ASSOC);
if (!$serverRow) {
    echo "Belirtilen sunucu bulunamadı.";
    exit;
}
$sunucu_id = $serverRow['id'];

// İlgili hosting kaydını al (kullanıcı adı ve sunucu_id bazında)
$sorgu = $db->prepare("SELECT * FROM hosting_hesaplari WHERE kullanici_adi = ? AND sunucu_id = ?");
$sorgu->execute([$user, $sunucu_id]);
$hosting_accounts = $sorgu->fetchAll(PDO::FETCH_ASSOC);

if (!$hosting_accounts) {
    echo "Belirtilen hosting hesabı bulunamadı.";
    exit;
}

// Form gönderildiğinde hosting sahip güncelleme işlemini gerçekleştir
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_hosting'])) {
    $basarili = 0;
    $hatali = 0;
    $hosting_matches = $_POST['hosting_matches'] ?? [];
    
    // Beklenen format: "kullanici_adi|sunucu_id|yeni_musteri_id"
    foreach ($hosting_matches as $hosting_data) {
         list($username, $serverId, $new_musteri_id) = explode('|', $hosting_data);
         try {
             $update = $db->prepare("UPDATE hosting_hesaplari SET musteri_id = ? WHERE kullanici_adi = ? AND sunucu_id = ?");
             $update->execute([$new_musteri_id, $username, $serverId]);
             $basarili++;
         } catch(PDOException $e) {
             error_log("Hosting Update Error: " . $e->getMessage());
             $hatali++;
         }
    }
    // İşlem sonucunu URL parametreleriyle tekrar aynı sayfaya yönlendirerek gösterelim
    header("Location: index.php?sayfa=aktarim/hosting_aktar&user=" . urlencode($user) . "&server=" . urlencode($serverName) . "&mesaj=update_completed&basarili=" . $basarili . "&hatali=" . $hatali);
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Hosting Sahip Güncelleme</title>
    <!-- CSS Kütüphaneleri: Bootstrap Icons, DataTables, Select2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
</head>
<body>
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.php">Anasayfa</a></li>
            <li class="breadcrumb-item"><a href="index.php?sayfa=hosting">Hosting Hesapları</a></li>
            <li class="breadcrumb-item active" aria-current="page">Sahip Değiştir</li>
        </ol>
    </nav>
    
    <?php if (isset($_GET['mesaj']) && $_GET['mesaj'] == 'update_completed'): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="bi bi-check-circle-fill me-2"></i>
        Güncelleme işlemi tamamlandı.<br>
        <strong><?php echo $_GET['basarili']; ?></strong> kayıt başarıyla güncellendi.
        <?php if ($_GET['hatali'] > 0): ?>
            <br><strong><?php echo $_GET['hatali']; ?></strong> kayıt güncellenemedi.
        <?php endif; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>
    
    <!-- Hosting Sahip Güncelleme Kartı -->
    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0">
                <i class="bi bi-hdd-rack me-2"></i>
                Hosting Sahip Güncelleme
            </h5>
        </div>
        <div class="card-body">
            <form method="POST" action="">
                <input type="hidden" name="update_hosting" value="1">
                <div class="table-responsive">
                    <table id="hostingTable" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Kullanıcı Adı</th>
                                <th>Domain</th>
                                <th>Sunucu</th>
                                <th>Paket</th>
                                <th>Durum</th>
                                <th>Müşteri</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($hosting_accounts as $account): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($account['kullanici_adi']); ?></td>
                                <td><?php echo htmlspecialchars($account['domain']); ?></td>
                                <td><?php echo htmlspecialchars($serverName); ?></td>
                                <td><?php echo htmlspecialchars($account['paket']); ?></td>
                                <td>
                                    <?php if ($account['durum'] == 'Askıda'): ?>
                                        <span class="badge bg-warning">
                                            <i class="bi bi-pause-circle me-1"></i>
                                            Askıda
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-success">
                                            <i class="bi bi-check-circle me-1"></i>
                                            Aktif
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <select name="hosting_matches[]" class="form-select form-select-sm select2">
                                        <?php 
                                        // Mevcut musteri_id (boşsa "Müşteri Seçin" seçeneği seçili olsun)
                                        $current = $account['musteri_id'] ?? '';
                                        ?>
                                        <option value="<?php echo $account['kullanici_adi'] . '|' . $sunucu_id . '|' . ''; ?>" <?php echo ($current == '') ? 'selected' : ''; ?>>Müşteri Seçin</option>
                                        <?php foreach ($musteriler as $musteri): ?>
                                        <option value="<?php echo $account['kullanici_adi'] . '|' . $sunucu_id . '|' . $musteri['id']; ?>" <?php echo ($current == $musteri['id']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($musteri['ad'] . ' ' . $musteri['soyad']); ?>
                                            (<?php echo $musteri['musteri_turu']; ?>)
                                        </option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-arrow-repeat me-2"></i>
                    Hosting Sahiplerini Güncelle
                </button>
            </form>
        </div>
    </div>
    
    <!-- jQuery, DataTables ve Select2 JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
        
        $('#hostingTable').DataTable({
            language: {
                url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/tr.json'
            },
            pageLength: 10,
            lengthMenu: [[10,25,50,100,-1], [10,25,50,100,"Tümü"]],
            order: [[0,'asc']],
            responsive: true,
            dom: "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                 "<'row'<'col-sm-12'tr>>" +
                 "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            initComplete: function() {
                $('.dataTables_filter input')
                    .attr('placeholder', 'Ara...')
                    .addClass('form-control-sm');
                $('.dataTables_length select').addClass('form-select-sm');
            }
        });
    });
    </script>
</body>
</html>
<?php ob_end_flush(); ?>
